#include <iostream>
#include <thread>
#include "Windows.h"
#include "conio.h"
using namespace std;

class Controller1
{
public:
	HANDLE hExitEvent;
	Controller1(HANDLE& h) : hExitEvent(h) { }
	void operator() ()
	{
		_getch(); 
		SetEvent(hExitEvent);
	}
};

class Reader
{
private:
	HANDLE hFileHandle,
		   hExitEvent;
	unsigned long nBytesToRead = 1024, 
		          nReadBytes = 0;
	unsigned char* pBuffer;
	OVERLAPPED Overlapped;
public:
	Reader(HANDLE& h1, HANDLE& h2) : hFileHandle(h1), hExitEvent(h2)
	{ 
		memset(&Overlapped, 0, sizeof Overlapped);
		Overlapped.hEvent = CreateEventA(NULL, FALSE, FALSE, NULL);
		pBuffer = new unsigned char[nBytesToRead];
	}

	~Reader()
	{
		if (pBuffer)
			delete pBuffer;
		if (hFileHandle != INVALID_HANDLE_VALUE)
			CloseHandle(hFileHandle);
		CloseHandle(Overlapped.hEvent);
	}

	void operator() ()
	{
		HANDLE hEvents[] = { Overlapped.hEvent, hExitEvent };
		if (!ReadFile(hFileHandle, pBuffer, nBytesToRead, &nReadBytes, &Overlapped))
		{
			int error = GetLastError();
			switch(error)
			{
			case ERROR_IO_PENDING:
				switch (WaitForMultipleObjects(2, hEvents, FALSE, 60 * 1000))
				{
				case WAIT_OBJECT_0:
					GetOverlappedResult(hFileHandle, &Overlapped, &nReadBytes, FALSE);
					break;
				case WAIT_OBJECT_0 + 1:
					cout << "Reading broken off" << endl;
					return;
				case WAIT_TIMEOUT:
					cout << "Timeout period 1 minute elapsed, nothing was received. Press a key to exit" << endl;
					return;
				default:
					cout << "Reading failed, error " << GetLastError() << ". Press a key to exit" << endl;
					return;
				}
			default:
				cout << "Reading failed, error " << GetLastError() << ". Press a key to exit" << endl;
				return;
			}
		}
		cout << nReadBytes << " was read" << endl;
		HANDLE hResultsFile = CreateFileA("C:\\Temp\\Results.txt", GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, NULL, NULL);
		if (hResultsFile == INVALID_HANDLE_VALUE)
		{
			cout << "File of results not created, error " << GetLastError() << endl;
			return;
		}
		unsigned long nWrittenBytes;
		int Result = WriteFile(hResultsFile, pBuffer, nReadBytes, &nWrittenBytes, NULL);
		if (!Result)
			cout << "Data not written, error " << GetLastError() << endl;
		else if (nReadBytes != nWrittenBytes)
			cout << "Only " << nWrittenBytes << " bytes instead of " << nReadBytes << " was written" << endl;
		else
			cout << nWrittenBytes << " bytes was written" << endl;
		CloseHandle(hResultsFile);
	}
};

void WindowsAsyncIO()
{
	HANDLE hFile = CreateFileA("\\\\.\\COM1", GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
	if (hFile == INVALID_HANDLE_VALUE)
	{
		cout << "File not created, error " << GetLastError() << endl;
		return;
	}
	HANDLE hExitEvent = CreateEventA(NULL, TRUE, FALSE, NULL);
	thread ControllerThread { Controller1(hExitEvent) };
	thread ReaderThread { Reader(hFile, hExitEvent) };
	ReaderThread.join();
	ControllerThread.join();
	CloseHandle(hExitEvent);
}